#include <bits/stdc++.h>
using namespace std;

typedef pair <int, int> pii;

const int MAXN = 5e5 + 5;

struct Edge {
  int from, to, idx;
};

int N, K;
int dp[MAXN];
vector <int> nodes;
vector <int> ch[MAXN];
vector <pii> adj[MAXN];
vector <pii> dir[MAXN], undir[MAXN];
int disc[MAXN], low[MAXN];
bool act[MAXN], can[MAXN];
int in[MAXN], out[MAXN];
int timer;

void add_node(int u) {
  if (act[u])
    return;
  nodes.push_back(u);
  act[u] = true;
}

void remove_node(int u) {
  disc[u] = 0;
  act[u] = false;
  in[u] = out[u] = 0;
  undir[u].clear();
}

void update_degree(int u, int v) {
  in[v]++;
  out[u]++;
  add_node(u);
  add_node(v);
}

void add_edge(int u, int v, int w) {
  undir[u].push_back({v, w});
  undir[v].push_back({u, w});
  update_degree(u, v);
}

void dfs_bridges(int x, int p, bool f) {
  disc[x] = low[x] = ++timer;
  for (auto it : undir[x])
    if (!disc[it.first]) {
      dfs_bridges(it.first, it.second, f);
      if (low[it.first] < disc[it.first])
        low[x] = min(low[x], low[it.first]);
      else if (f)
        can[it.second] = false;
    }
    else if (it.second != p)
      low[x] = min(low[x], disc[it.first]);
}

void euler_walk(int curr, int edge, int node) {
  while (!dir[curr].empty()) {
    pii nxt = dir[curr].back();
    dir[curr].pop_back();
    euler_walk(nxt.first, nxt.second, node);
  }
  if (edge)
    ch[node].push_back(edge);
}

int least_last(int node, int st, int en, vector <Edge> edges) {
  if (edges.empty())
    return 0;
  for (auto it : edges) 
    add_edge(it.from, it.to, it.idx);
  dfs_bridges(en, -1, in[en] > 1);
  int best = 0;
  for (auto it : edges)
    if (it.to == en && can[it.idx] && dp[it.idx] < dp[best])
      best = it.idx;
  update_degree(en, st);
  for (; !nodes.empty(); nodes.pop_back()) {
    if (in[nodes.back()] != out[nodes.back()] || !disc[nodes.back()])
      best = 0;
    remove_node(nodes.back());
  }
  if (best) {
    for (auto it : edges)
      if (it.idx != best)
        dir[it.from].push_back({it.to, it.idx});
    euler_walk(st, 0, node);
    reverse(ch[node].begin(), ch[node].end());
    ch[node].push_back(best);
  }
  return dp[best];
}

void load() {
  scanf("%d%d", &N, &K);
  for (int i = 1; i < N; i++) {
    int u, v, w;
    scanf("%d%d%d", &u, &v, &w);
    adj[u].push_back({v, w - 1});
    adj[v].push_back({u, w - 1});
  }
}

int dfs_solve(int x, int p, int e) {
  int sub = 1;
  vector <Edge> edges;
  auto add = [](int a, int b) -> int {
    a += b;
    return a < K ? a : a - K;
  };
  for (auto it : adj[x])
    if (it.first != p) {
      int sz = dfs_solve(it.first, x, it.second);
      edges.push_back({it.second, add(it.second, sz), it.first});
      sub = add(sub, sz);
    }
  dp[x] = least_last(x, add(e, 1), add(e, sub), edges) + (x > 1);
  return sub;
}

void construct(int x) {
  printf("%d ", x);
  for (auto it : ch[x]) {
    construct(it);
    printf("%d ", x);
  }
}

void solve() {
  dp[0] = MAXN;
  memset(can, true, sizeof can);
  dfs_solve(1, 0, K - 1);
  int sol = *max_element(dp + 1, dp + N + 1);
  if (sol >= MAXN) {
    puts("-1");
    return;
  }
  printf("%d\n", sol);
  construct(1);
  puts("");
}

int main() {
  load();
  solve();
  return 0;
}
